/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import com.geolang.ascema.domainmodelpublic.IPatternMatchResult;
import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.domainmodelpublic.ResultStatusReason;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchResult;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.NamedArea;
import com.geolang.ascema.endpointcommon.domain.PasswordProtectedResult;
import com.geolang.ascema.endpointcommon.domain.QuarantineResult;
import com.geolang.ascema.endpointcommon.domain.RetrievalResult;
import com.geolang.ascema.endpointcommon.domain.UnprocessableFileResult;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.messages.ServerErrorAuditLogMessage;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.auditlog.AuditLogFormat;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.BaseMatchStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.MatchStored;
import com.geolang.ascema.managerdomain.domain.PatternIgnore;
import com.geolang.ascema.managerdomain.domain.SavedPattern;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.SecondaryConfig;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerservice.auditlog.AuditLogEventType;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.auditlog.ECSLogEvent;
import com.geolang.ascema.managerservice.auditlog.EmitterService;
import com.geolang.ascema.managerservice.auditlog.ILogAppender;
import com.geolang.ascema.managerservice.auditlog.ILogEvent;
import com.geolang.ascema.managerservice.auditlog.SplunkEvent;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.invoke.CallSite;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AuditLogService {
    private static final Logger LOG = Logger.getLogger(AuditLogService.class.getName());
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    @Autowired
    @Lazy
    private DeviceService endpointService;
    private final EmitterService emitter = new EmitterService();

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
        this.emitter.destroy();
    }

    private ILogEvent createEvent(AuditLogEventType type) {
        AuditLogFormat format = SettingsFile.getInstance().getAuditLogFormat();
        switch (1.$SwitchMap$com$geolang$ascema$managercore$auditlog$AuditLogFormat[format.ordinal()]) {
            case 1: {
                return new ECSLogEvent(type);
            }
            case 2: {
                return new SplunkEvent(type);
            }
        }
        throw new RuntimeException("Unsupported log format");
    }

    @Subscribe
    public void handleSessionChange(SessionChangeEvent ev) {
        AuditLogEventType cat = null;
        Optional reg = this.endpointService.getDeviceFromId(ev.getDeviceId(), true);
        if (reg.isPresent()) {
            DeviceRegistration dr = (DeviceRegistration)reg.get();
            switch (1.$SwitchMap$com$geolang$ascema$managerevents$SessionChangeEvent$Reason[ev.getReason().ordinal()]) {
                case 1: {
                    cat = AuditLogEventType.DEVICE_JOIN;
                    break;
                }
                case 2: 
                case 3: {
                    cat = AuditLogEventType.DEVICE_LEAVE;
                    break;
                }
            }
            if (cat != null) {
                ILogEvent out = this.createEvent(cat);
                out.addDeviceParts(dr);
                this.emit(out);
            }
        }
    }

    public void logStart() {
        ILogEvent out = this.createEvent(AuditLogEventType.SERVICE_START);
        this.emit(out);
    }

    public void logStop() {
        ILogEvent out = this.createEvent(AuditLogEventType.SERVICE_STOP);
        this.emit(out);
    }

    public void quarantineEvent(TaskManager taskManager, QuarantineResult res) {
        AuditLogEventType cat;
        if (res == null) {
            return;
        }
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$QuarantineResult$TYPE[res.getType().ordinal()]) {
            case 1: {
                cat = AuditLogEventType.QUARANTINE;
                break;
            }
            case 2: {
                cat = AuditLogEventType.QUARANTINE_DELETE;
                break;
            }
            case 3: {
                cat = AuditLogEventType.QUARANTINE_REVERT;
                break;
            }
            default: {
                LOG.log(Level.WARNING, "unknown quarantine event type {0}", res);
                return;
            }
        }
        ILogEvent out = this.createEvent(cat);
        this.appendDeviceStrings(res.getDeviceId(), out);
        this.appendFilePathStrings(res.getFilePath(), out);
        Optional opt = taskManager.getTaskInstanceFromId(res.getJobId());
        this.appendTaskInstanceStrings(opt, out);
        out.addEventReason(res.isSuccess(), res.getFailureReason());
        this.emit(out);
    }

    public void unProcessableFileSeen(TaskManager taskManager, UnprocessableFileResult result) {
        AuditLogEventType cat = AuditLogEventType.UNPROCESSABLE_FILE;
        ILogEvent out = this.createEvent(cat);
        this.appendFilePathStrings(result.getFilePath(), out);
        out.addEventReason(false, result.getReason());
        this.appendDeviceStrings(result.getDeviceId(), out);
        Optional opt = taskManager.getTaskInstanceFromId(result.getJobId());
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void passwordProtectedFileSeen(TaskManager taskManager, PasswordProtectedResult result) {
        AuditLogEventType cat = AuditLogEventType.PASSWORD_PROTECTED_FILE;
        ILogEvent out = this.createEvent(cat);
        this.appendFilePathStrings(result.getFilePath(), out);
        this.appendDeviceStrings(result.getDeviceId(), out);
        Optional opt = taskManager.getTaskInstanceFromId(result.getJobId());
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void retrievalAdded(TaskManager taskManager, RetrievalResult sr) {
        AuditLogEventType cat = AuditLogEventType.RETRIEVAL_RESULT;
        ILogEvent out = this.createEvent(cat);
        String matchstr = PatternMatchResult.getPatternMatchesAsDisplayString((Collection)sr.getResults());
        out.addSigniture(matchstr);
        this.appendFilePathStrings(sr.getFilePath(), out);
        out.setUsers(sr.getUserOrOtherName(), sr.getOwner());
        out.setRetrievalParts(sr);
        this.appendDeviceStrings(sr.getDeviceId(), out);
        NamedArea na = sr.getNamedArea();
        if (na != null && !na.equals((Object)NamedArea.none())) {
            out.setArea(na.getAreaDescription());
        }
        Optional opt = taskManager.getTaskInstanceFromId(sr.getJobId());
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void resultsAdded(TaskManager taskManager, DatabaseSearchResult sr) {
        SettingsFile settings = SettingsFile.getInstance();
        Optional opt = taskManager.getTaskInstanceFromId(sr.getJobId());
        if (settings.getAuditIndividualMatches()) {
            this.addDbResultForEachMatch(opt, sr);
            return;
        }
        AuditLogEventType cat = AuditLogEventType.DB_MATCHES_FOUND;
        ILogEvent out = this.createEvent(cat);
        String matchstr = this.getPatternMatchesAsDisplayString((Collection)sr.getResults());
        out.addSigniture(matchstr);
        this.appendDeviceStrings(sr.getDeviceId(), out);
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void resultsAdded(TaskManager taskManager, SearchResultStored sr) {
        SettingsFile settings = SettingsFile.getInstance();
        Optional opt = taskManager.getTaskInstanceFromId(sr.getJobId());
        if (settings.getAuditIndividualMatches()) {
            this.addResultForEachMatch(opt, sr);
            return;
        }
        AuditLogEventType cat = AuditLogEventType.MATCHES_FOUND;
        ILogEvent out = this.createEvent(cat);
        String matchstr = this.getPatternMatchesAsDisplayString((Collection)sr.getMatchstored());
        out.addSigniture(matchstr);
        this.appendFilePathStrings(sr.getFilePath(), out);
        out.setUsers(sr.getUserOrOtherName(), sr.getOwner());
        out.addResultTopLevel(sr);
        Optional createdOpt = sr.getFileDates().getCreated();
        if (createdOpt.isPresent()) {
            out.setFileCreated(dateTimeFormatter.format((TemporalAccessor)createdOpt.get()));
        }
        out.setFileVersion(sr.isIsCurrentVersion());
        this.appendDeviceStrings(sr.getDeviceId(), out);
        NamedArea na = sr.getNamedArea();
        if (na != null) {
            out.setArea(na.getDisplayName());
        }
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    private String getPatternMatchesAsDisplayString(Collection<? extends IPatternMatchResult> patternMatches) {
        if (patternMatches == null || patternMatches.isEmpty()) {
            return "";
        }
        HashMap<CallSite, Integer> count = new HashMap<CallSite, Integer>();
        for (IPatternMatchResult iPatternMatchResult : patternMatches) {
            String display = iPatternMatchResult.getDisplayName() + " : Confidence " + String.valueOf(iPatternMatchResult.getConfidence());
            Integer i = (Integer)count.get(display);
            i = null == i ? Integer.valueOf(1) : Integer.valueOf(i + 1);
            count.put((CallSite)((Object)display), i);
        }
        StringBuilder ret = patternMatches.size() > 1 ? new StringBuilder("Patterns: ") : new StringBuilder("Pattern: ");
        for (String s : count.keySet()) {
            ret.append(s);
            Integer c = (Integer)count.get(s);
            if (c <= 1) continue;
            ret.append("(").append(c).append(")").append('\t');
        }
        return ret.toString();
    }

    private void addResultForEachMatch(Optional<TaskInstance> opt, SearchResultStored sr) {
        for (BaseMatchStored pm : sr.getMatchstored()) {
            AuditLogEventType cat = AuditLogEventType.MATCHES_FOUND;
            ILogEvent out = this.createEvent(cat);
            out.addResultParts(pm, sr);
            Optional createdOpt = sr.getFileDates().getCreated();
            if (createdOpt.isPresent()) {
                out.setFileCreated(dateTimeFormatter.format((TemporalAccessor)createdOpt.get()));
            }
            out.setFileVersion(sr.isIsCurrentVersion());
            this.appendFilePathStrings(sr.getFilePath(), out);
            out.setUsers(sr.getUserOrOtherName(), sr.getOwner());
            this.appendDeviceStrings(sr.getDeviceId(), out);
            NamedArea na = sr.getNamedArea();
            if (na != null) {
                out.setArea(na.getDisplayName());
            }
            this.appendTaskInstanceStrings(opt, out);
            this.emit(out);
        }
    }

    private void addDbResultForEachMatch(Optional<TaskInstance> opt, DatabaseSearchResult sr) {
        for (PatternMatchResult pm : sr.getResults()) {
            AuditLogEventType cat = AuditLogEventType.DB_MATCHES_FOUND;
            ILogEvent out = this.createEvent(cat);
            out.addResultParts(pm, sr);
            this.appendDeviceStrings(sr.getDeviceId(), out);
            this.appendTaskInstanceStrings(opt, out);
            this.emit(out);
        }
    }

    public void fileStatusChange(TaskManager taskManager, String user, String email, ResultStatus status, ResultStatusReason reason, String customReason, String taskId, String deviceId, String filePath) {
        AuditLogEventType cat = AuditLogEventType.FILE_STATUS_CHANGE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.setStatusReasons(status, reason, customReason);
        out.setAlertedEmail(email);
        this.appendFilePathStrings(filePath, out);
        this.appendDeviceStrings(deviceId, out);
        Optional opt = taskManager.getTaskInstanceFromId(taskId);
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void resultStatusChange(TaskManager taskManager, String user, String email, String taskId, String deviceId, Collection<MatchStored> results, String filePath) {
        if (results.isEmpty()) {
            return;
        }
        AuditLogEventType cat = AuditLogEventType.RESULT_STATUS_CHANGE;
        ILogEvent out = this.createEvent(cat);
        String matchstr = MatchStored.getPatternMatchesAsDisplayString(results);
        out.setUsers(user, "");
        MatchStored ms = results.iterator().next();
        out.setStatusReasons(ms.getStatus(), ms.getResultStatusReason(), ms.getCustomStatusReason());
        out.addSigniture(matchstr);
        out.setAlertedEmail(email);
        this.appendFilePathStrings(filePath, out);
        this.appendDeviceStrings(deviceId, out);
        Optional opt = taskManager.getTaskInstanceFromId(taskId);
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void templateCreated(String createdBy, TaskTemplate t) {
        AuditLogEventType cat = AuditLogEventType.TASK_CREATE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(createdBy, "");
        out.setTaskName(t.getDisplayName());
        this.emit(out);
    }

    public void templateDeleted(String deletedBy, TaskTemplate jpt) {
        AuditLogEventType cat = AuditLogEventType.TASK_DELETE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(deletedBy, "");
        out.setTaskName(jpt.getDisplayName());
        this.emit(out);
    }

    public void instanceCreated(TaskInstance instance) {
        AuditLogEventType cat = AuditLogEventType.TASK_INSTANCE_RUN;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(instance.getCreatedBy(), "");
        out.setTaskName(instance.getDisplayName());
        this.emit(out);
    }

    public void instanceDeleted(String deletedBy, TaskInstance instance) {
        AuditLogEventType cat = AuditLogEventType.TASK_INSTANCE_DELETE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(deletedBy, "");
        out.setTaskName(instance.getDisplayName());
        this.emit(out);
    }

    public void deviceBlocked(String by, DeviceRegistration dev) {
        AuditLogEventType cat = AuditLogEventType.DEVICE_BLOCKED;
        ILogEvent out = this.createEvent(cat);
        this.appendDeviceStrings(dev, out);
        out.setUsers(by, "");
        this.emit(out);
    }

    public void deviceAllowed(String by, DeviceRegistration dev) {
        AuditLogEventType cat = AuditLogEventType.DEVICE_ALLOWED;
        ILogEvent out = this.createEvent(cat);
        this.appendDeviceStrings(dev, out);
        out.setUsers(by, "");
        this.emit(out);
    }

    public void deviceDelete(String by, DeviceRegistration dev) {
        AuditLogEventType cat = AuditLogEventType.DEVICE_DELETE;
        ILogEvent out = this.createEvent(cat);
        this.appendDeviceStrings(dev, out);
        out.setUsers(by, "");
        this.emit(out);
    }

    public void deviceRoleChange(String by, DeviceRegistration dev, DeviceType oldType) {
        AuditLogEventType cat = AuditLogEventType.DEVICE_ROLE_CHANGE;
        ILogEvent out = this.createEvent(cat);
        this.appendDeviceStrings(dev, out);
        out.setUsers(by, "");
        out.setDevicePrevious(oldType.getDisplayName());
        this.emit(out);
    }

    public void followNetworkChange(String by, DeviceRegistration dev, boolean oldType) {
        AuditLogEventType cat = AuditLogEventType.DEVICE_ROLE_CHANGE;
        ILogEvent out = this.createEvent(cat);
        this.appendDeviceStrings(dev, out);
        out.setUsers(by, "");
        out.setDevicePrevious(Boolean.toString(oldType));
        this.emit(out);
    }

    public void removeSecondary(SecondaryConfig mgr) {
        AuditLogEventType cat = AuditLogEventType.SECONDARY_DELETED;
        ILogEvent out = this.createEvent(cat);
        out.setManagerName(mgr.getName());
        this.emit(out);
    }

    public void addSecondary(SecondaryConfig mgr) {
        AuditLogEventType cat = AuditLogEventType.SECONDARY_ADDED;
        ILogEvent out = this.createEvent(cat);
        out.setManagerName(mgr.getName());
        this.emit(out);
    }

    public void patternDeleted(String name, String user) {
        AuditLogEventType cat = AuditLogEventType.PATTERN_DELETE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.addPatternParts(name, "");
        this.emit(out);
    }

    public void patternCreated(SavedPattern sp, String user) {
        AuditLogEventType cat = AuditLogEventType.PATTERN_ADD;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.addPatternParts(sp.getSavedName(), sp.getType().name());
        this.emit(out);
    }

    public void patternIgnoreDeleted(String user, PatternIgnore ig) {
        AuditLogEventType cat = AuditLogEventType.PATTERN_UNIGNORE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.addPatternParts(ig.getPatternName(), ig.getIgnore());
        this.emit(out);
    }

    public void patternIgnoreCreated(String user, PatternIgnore ig) {
        AuditLogEventType cat = AuditLogEventType.PATTERN_IGNORE;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.addPatternParts(ig.getPatternName(), ig.getIgnore());
        this.emit(out);
    }

    public void importDone(String user) {
        AuditLogEventType cat = AuditLogEventType.IMPORT;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        this.emit(out);
    }

    public void exportDone(String user) {
        AuditLogEventType cat = AuditLogEventType.EXPORT;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        this.emit(out);
    }

    public void logAlertNotification(TaskManager taskManager, String taskId, String deviceId, String email, boolean emailSendStatus) {
        AuditLogEventType cat = emailSendStatus ? AuditLogEventType.ALERT_SUCCESS : AuditLogEventType.ALERT_FAIL;
        ILogEvent out = this.createEvent(cat);
        out.setAlertedEmail(email);
        this.appendDeviceStrings(deviceId, out);
        if (taskId != null) {
            Optional opt = taskManager.getTaskInstanceFromId(taskId);
            this.appendTaskInstanceStrings(opt, out);
        }
        this.emit(out);
    }

    public void logActionStatus(TaskStore taskManager, ActionResult res, String deviceId, String taskInstanceId) {
        AuditLogEventType cat = AuditLogEventType.ACTION_STATUS_MESSAGE;
        ILogEvent out = this.createEvent(cat);
        out.addFileParts(res.getPath(), "", "", res.getArea().getDisplayName());
        out.setActionParts(res);
        this.appendDeviceStrings(deviceId, out);
        Optional opt = taskManager.getTaskInstanceFromId(taskInstanceId);
        this.appendTaskInstanceStrings(opt, out);
        this.emit(out);
    }

    public void logKnowledgeBaseSearch(String query, String user) {
        AuditLogEventType cat = AuditLogEventType.KNOWLEDGE_BASE_SEARCH;
        ILogEvent out = this.createEvent(cat);
        out.setQuery(user, query);
        this.emit(out);
    }

    public void logClassificationCreated(String className, String user) {
        AuditLogEventType cat = AuditLogEventType.CLASSIFICATION_CREATED;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.setClassificationName(className);
        this.emit(out);
    }

    public void logClassificationDeleted(String className, String user) {
        AuditLogEventType cat = AuditLogEventType.CLASSIFICATION_DELETED;
        ILogEvent out = this.createEvent(cat);
        out.setUsers(user, "");
        out.setClassificationName(className);
        this.emit(out);
    }

    public void auditServerError(TaskManager taskManager, ServerErrorAuditLogMessage msg) {
        AuditLogEventType cat = AuditLogEventType.PLATFORM_SERVER_ERROR;
        ILogEvent out = this.createEvent(cat);
        out.addFileParts(msg.getFilePath(), "", msg.getHost(), msg.getArea().getDisplayName());
        out.addEventReason(false, msg.getErrorMessage());
        this.appendDeviceStrings(msg.getDeviceId(), out);
        if (msg.getTaskInstanceId() != null) {
            Optional opt = taskManager.getTaskInstanceFromId(msg.getTaskInstanceId());
            this.appendTaskInstanceStrings(opt, out);
        }
        this.emit(out);
    }

    void emit(ILogEvent ev) {
        this.emitter.emit(ev);
    }

    public void setAppenders(List<ILogAppender> logs) {
        this.emitter.setAppenders(logs);
    }

    private void appendDeviceStrings(String deviceId, ILogEvent ev) {
        Optional dd = this.endpointService.getDeviceFromId(deviceId, true);
        if (dd.isPresent()) {
            this.appendDeviceStrings((DeviceRegistration)dd.get(), ev);
        }
    }

    private void appendDeviceStrings(DeviceRegistration dd, ILogEvent ev) {
        ev.addDeviceParts(dd);
    }

    private void appendTaskInstanceStrings(Optional<TaskInstance> opt, ILogEvent ev) {
        if (opt.isPresent()) {
            ev.addTaskInstanceParts(opt.get());
        }
    }

    private void appendFilePathStrings(String path, ILogEvent out) {
        out.addFileParts(path);
    }
}

