/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.auditlog.LogFileAppender;
import com.geolang.ascema.managerservice.auditlog.TcpLog;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditLogConfigurator {
    @Autowired
    private AuditLogService logService;
    private TcpLog splunkTcp = null;
    private LogFileAppender fileAppender = null;

    @PreDestroy
    public void destroy() throws Exception {
        this.logService.logStop();
        if (this.splunkTcp != null) {
            this.splunkTcp.stop();
            this.splunkTcp = null;
        }
    }

    @PostConstruct
    public void init() {
        ArrayList<Object> appenders = new ArrayList<Object>();
        this.fileAppender = new LogFileAppender();
        appenders.add(this.fileAppender);
        SettingsFile settings = SettingsFile.getInstance();
        if (settings.getUseSplunkTcp()) {
            this.splunkTcp = new TcpLog();
            appenders.add(this.splunkTcp);
        }
        this.logService.setAppenders(appenders);
        this.logService.logStart();
    }

    public Optional<Path> getLogFilePath() {
        return this.fileAppender.getLogFilePath();
    }

    public void updateAppenders() {
        ArrayList<Object> appenders = new ArrayList<Object>();
        appenders.add(this.fileAppender);
        SettingsFile settings = SettingsFile.getInstance();
        if (this.splunkTcp != null) {
            this.splunkTcp.stop();
            this.splunkTcp = null;
        }
        if (settings.getUseSplunkTcp()) {
            this.splunkTcp = new TcpLog();
            appenders.add(this.splunkTcp);
        }
        this.logService.setAppenders(appenders);
    }
}

