/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice;

import com.geolang.ascema.managerservice.rest.SettingsRestService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingSettings {
    static void setLoggingProperties(String workingFolder) {
        System.setProperty("logging.file.name", workingFolder + File.separator + "logs" + File.separator + "manager-log.txt");
        System.setProperty("logging.errorfile.name", workingFolder + File.separator + "logs" + File.separator + "manager-error-log.txt");
    }

    public static String getServerLog() {
        Path path = Paths.get(System.getProperty("logging.file.name"), new String[0]);
        StringBuilder serverlog = new StringBuilder();
        try {
            serverlog.append(Files.readString(path, StandardCharsets.ISO_8859_1));
            path = Paths.get(System.getProperty("logging.errorfile.name"), new String[0]);
            String errors = Files.readString(path, StandardCharsets.ISO_8859_1);
            if (errors != null && !errors.isEmpty()) {
                serverlog.append("=====  ERRORS =====\n");
                serverlog.append(errors);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SettingsRestService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return serverlog.toString();
    }
}

