/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.controllers.jettyssl.JettySSL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JettyConfig
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    private static final Logger LOG = Logger.getLogger(JettyConfig.class.getName());
    @Autowired
    private JettySSL jettyssl;

    public void customize(ConfigurableServletWebServerFactory factory) {
        SettingsFile settings = SettingsFile.getInstance();
        int port = settings.getUIPort();
        factory.setPort(port);
        Optional opt = this.jettyssl.getSsl();
        if (opt.isPresent()) {
            LOG.log(Level.INFO, "Using SSL");
            port = settings.getUISSLPort();
            Ssl ssl = (Ssl)opt.get();
            ssl.setEnabled(true);
            factory.setSsl(ssl);
            factory.setPort(port);
        }
        LOG.log(Level.INFO, "port is {0}", port);
    }
}

