/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.db.ManagerDatabaseCredentials;
import com.zaxxer.hikari.HikariDataSource;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DbConfig {
    @Primary
    @Bean
    public DataSource userDataSource() {
        ManagerDatabaseCredentials creds = ManagerDatabaseCredentials.getInstance();
        DataSource ret = creds.allGood() ? this.createFromConfig(creds) : this.createDerbyDb();
        if (ret instanceof HikariDataSource) {
            int maxConnections = SettingsFile.getInstance().getMaxDbConnections();
            ((HikariDataSource)ret).setMaximumPoolSize(maxConnections);
            ((HikariDataSource)ret).setMinimumIdle(5);
            ((HikariDataSource)ret).setPoolName("Main DB Pool");
            ((HikariDataSource)ret).setConnectionTimeout(60000L);
        }
        return ret;
    }

    @LiquibaseDataSource
    @Bean
    public DataSource liquibaseDataSource() {
        ManagerDatabaseCredentials creds = ManagerDatabaseCredentials.getInstance();
        int liquibaseTimeoutMins = SettingsFile.getInstance().getLiquibaseTimeout();
        Logger.getLogger(DbConfig.class.getName()).log(Level.INFO, "liquibase timeout {0} mins", liquibaseTimeoutMins);
        DataSource ret = creds.allGood() ? this.createFromConfig(creds) : this.createDerbyDb();
        if (ret instanceof HikariDataSource) {
            ((HikariDataSource)ret).setMaximumPoolSize(2);
            ((HikariDataSource)ret).setPoolName("Liquibase Pool");
            ((HikariDataSource)ret).setConnectionTimeout((long)(liquibaseTimeoutMins * 60 * 1000));
        }
        return ret;
    }

    private DataSource createDerbyDb() {
        System.setProperty("derby.system.home", WorkingFolder.getDbFolder());
        System.setProperty("derby.storage.pageSize", "32768");
        System.setProperty("derby.storage.pageCacheSize", "10000");
        return DataSourceBuilder.create().driverClassName("org.apache.derby.iapi.jdbc.AutoloadedDriver").username("app").password("").url("jdbc:derby:serverdb;create=true").build();
    }

    private DataSource createFromConfig(ManagerDatabaseCredentials creds) {
        Logger.getLogger(DbConfig.class.getName()).log(Level.INFO, "loading {0}", creds.getClassName());
        try {
            Class.forName(creds.getClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DbConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        return DataSourceBuilder.create().driverClassName(creds.getClassName()).username(creds.getUser()).password(creds.getPwd()).url(creds.getUrl()).build();
    }
}

