/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice;

import com.geolang.ascema.managerservice.ApplicationContextDumper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class ApplicationContextDumper {
    private final Map<String, Integer> beanReferenceCounter = new HashMap();
    private final Map<String, List<String>> map = new HashMap();
    private final ApplicationContext context;

    public ApplicationContextDumper(ApplicationContext context) {
        this.context = context;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void afterPropertiesSet() throws Exception {
        this.beanReferenceCounter.clear();
        System.out.println("--- ApplicationContextDumper begin ---\n");
        this.dumpApplicationContext(this.context);
        this.checkCircles();
        System.out.println("--- ApplicationContextDumper end ---\n");
    }

    private void dumpBeansWithoutReference() {
        System.out.println("Beans without reference:\n");
        for (String bean : this.beanReferenceCounter.keySet()) {
            if ((Integer)this.beanReferenceCounter.get(bean) != 0) continue;
            System.out.println("  " + bean + "\n");
        }
    }

    private void initBeanReferenceIfNotExist(String beanName) {
        Integer count = (Integer)this.beanReferenceCounter.get(beanName);
        if (count == null) {
            this.beanReferenceCounter.put(beanName, 0);
        }
    }

    private void increaseBeanReference(String beanName) {
        Integer count = (Integer)this.beanReferenceCounter.get(beanName);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.beanReferenceCounter.put(beanName, count);
    }

    private void dumpApplicationContext(ApplicationContext context) {
        Object appContextInfo = String.format("ApplicationContext %s : %s", context.getId(), context.getClass().getName());
        ApplicationContext parent = context.getParent();
        if (parent != null) {
            appContextInfo = (String)appContextInfo + String.format(" -> %s", parent.getId());
        }
        System.out.println((String)appContextInfo + "\n");
        ConfigurableListableBeanFactory factory = ((AnnotationConfigServletWebServerApplicationContext)context).getBeanFactory();
        for (String beanName : factory.getBeanDefinitionNames()) {
            if (factory.getBeanDefinition(beanName).isAbstract() || factory.getBeanDefinition(beanName).getScope().equals("session")) continue;
            this.initBeanReferenceIfNotExist(beanName);
            Object bean = factory.getBean(beanName);
            if (!bean.getClass().getName().startsWith("com.geolang")) continue;
            this.map.put(beanName, new ArrayList());
            System.out.println(String.format("  %s : %s\n", beanName, bean.getClass().getName()));
            for (String dependency : factory.getDependenciesForBean(beanName)) {
                System.out.println(String.format("    -> %s\n", dependency));
                this.increaseBeanReference(dependency);
                ((List)this.map.get(beanName)).add(dependency);
            }
        }
        if (parent != null) {
            System.out.println("Parent:\n");
            this.dumpApplicationContext(parent);
        }
    }

    private void checkCircles() {
        for (String bean : this.map.keySet()) {
            Node top = new Node(null, bean);
            this.checkChildren(top);
        }
    }

    private void checkChildren(Node top) {
        List childs = (List)this.map.get(top.name);
        if (childs != null) {
            for (String bean : childs) {
                Node thisNode;
                Node n = thisNode = new Node(top, bean);
                StringBuilder builder = new StringBuilder(n.name);
                while (n.parent != null) {
                    builder.append("<-").append(n.parent.name);
                    if (n.parent.name.equals(bean)) {
                        System.err.println("###ERROR### " + builder.toString());
                        return;
                    }
                    n = n.parent;
                }
                this.checkChildren(thisNode);
            }
        }
    }
}

