/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.LoggingSettings;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableAsync
@EnableTransactionManagement
@EnableScheduling
@EntityScan(value={"com.geolang.ascema.managerservice", "com.geolang.ascema.managerdomain"})
@ComponentScan(value={"com.geolang.ascema.managerservice", "com.geolang.ascema.managerpersistence", "com.geolang.ascema.managerdomain"})
@EnableJpaRepositories(value={"com.geolang.ascema.managerpersistence"})
public class Application {
    private static final Logger LOG = Logger.getLogger(Application.class.getName());
    private static ClassLoader mainThreadClassLoader;
    private static ConfigurableApplicationContext context;
    private static String[] clArgs;

    public static void main(String[] args) {
        clArgs = args;
        Application.start();
    }

    public static void restart() {
        LOG.info("Restart called");
        Thread restartThread = new Thread(() -> {
            try {
                context.close();
                SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Application.class});
                context = builder.run(clArgs);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "restart exit", ex);
                System.exit(1);
            }
        });
        restartThread.setContextClassLoader(mainThreadClassLoader);
        restartThread.setDaemon(false);
        restartThread.start();
    }

    private static void start() {
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
        System.setProperty("jdk.tls.namedGroups", "secp256r1, secp384r1, ffdhe2048, ffdhe3072");
        String workingFolder = WorkingFolder.getWorkingFolder();
        LoggingSettings.setLoggingProperties((String)workingFolder);
        System.setProperty("activemq.store.dir", workingFolder + File.separator + "amq");
        System.setProperty("org.apache.activemq.default.directory.prefix", workingFolder + File.separator + "amq");
        try {
            mainThreadClassLoader = Thread.currentThread().getContextClassLoader();
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Application.class});
            context = builder.run(clArgs);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "start exit", ex);
            System.exit(1);
        }
    }

    public static void shutdown() {
        SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }
}

